'use strict';

angular.module('genisis').service('user', ['api', 'session', '$location',
  '$rootScope', 'system',
  function ($api, $session, $location, $rootScope, $system) {
    //try to load an existing user session
    var service = this;
    var _user = $session.get('user');
    var _primaryUser = {};
    var _testAble = false;
    // Array of elevated Users
    // var _elevatedUsers = $system.elevatedUsers();

    this.setTestAble = function () {
      // Use this block if we want to include in SQA
      // _testAble = (
      //     _elevatedUsers.includes(_primaryUser.emailId) &&
      //     $system.vaDevelopment()
      //   ) ||
      //   $system.isAWSTestEnv();
      _testAble = $system.isAWSTestEnv();
    };

    // Initialize _testAble;
    this.setTestAble();

    this.testAble = function () {
      return _testAble;
    };

    var _testUsers = [{
      name: 'researcher1',
      value: 'genisisresearcher1@PII'
    }, {
      name: 'researcher2',
      value: 'genisisresearcher2@PII',
    }, {
      name: 'researcher3',
      value: 'genisisresearcher3@PII',
    }, {
      name: 'researcher4',
      value: 'genisisresearcher4@PII',
    }, {
      name: 'Genisis2 Manager1',
      value: 'genisismgr1@PII'
    }, {
      name: 'Genisis2 Manager2',
      value: 'genisismgr2@PII'
    }, {
      name: 'Genisis2 Manager3',
      value: 'genisismgr3@PII'
    }, {
      name: 'Genisis2 Manager4',
      value: 'genisismgr4@PII'
    }, {
      name: 'GSA1 ( Sys Admin)',
      value: 'genisisad1@PII'
    }, {
      name: 'GSA2 ( Sys Admin)',
      value: 'genisisad2@PII'
    }, {
      name: 'GSA3 ( Sys Admin)',
      value: 'genisisad3@PII'
    }, {
      name: 'GSA4 ( Sys Admin)',
      value: 'genisisad4@PII'
    }, {
      name: 'Vinci Manager1',
      value: 'vincimgr1@PII'
    }, {
      name: 'Vinci Manager2',
      value: 'vincimgr2@PII'
    }, {
      name: 'Vinci Manager3',
      value: 'vincimgr3@PII'
    }, {
      name: 'Vinci Manager4',
      value: 'vincimgr4@PII'
    }];

    this.findSelectedUser = function () {
      var user = {};
      for (var i = 0; i < _testUsers.length; i++) {
        if (_testUsers[i].value === _user.emailId) {
          user = _testUsers[i];
        }
      }
      return user;
    };

    this.userSelections = function () {
      return _testUsers;
    };

    /**
     * Return the user  object
     * @return Object the user's info
     **/
    this.info = function () {
      return _user;
    };

    this.testAble = function () {
      return _testAble;
    };

    this.primaryUser = function () {
      return _primaryUser;
    };

    this.setPrimaryUser = function (user) {
      if (Object.keys(_primaryUser).length === 0) {
        _primaryUser = user;
      }
    };

    /**
     * Login
     * @param string email
     * @param string password
     * @return boolean login status
     **/
    this.login = function (email) {
      var payload = {
        value: email,
        context: 'email',
        data: null
      };

      return $api.retrieve('users', payload).then(
        function (request) {
          if (request && request.success) {
            //update the user object with the api payload
            //  console.log(JSON.parse(request.response).status);
            if (request.response.status !== 'Active') {
              $location.path('/sso');
            } else {
              _user = request.response;
              //save the user session
              $session.set('user', _user);
              service.setPrimaryUser(_user);
              service.setTestAble();
              $location.path('/requests');
              $location.replace();
              return true;
            }
          } else if (request && request.message) {
            $rootScope.errors.push(request.message);
          } else {
            $rootScope.errors.push('Invalid API Response');
          }

          return false;
        }
      );
    };

    /**
     * Logging out of GenISIS system
     * Clear user session and redirect to the login page
     **/
    this.logout = function () {
      $session.delete();
      _user = {};
      _primaryUser = {};
      $location.path('/logout');
      $location.replace();
    };

    this.systemUserRefresh = function (email) {
      $session.delete();
      _user = {};
      $location.path('/');
      $location.replace();
      this.login(email);
    };

    /**
     * Return the name of the user id
     * @return int user id number
     **/
    this.id = function () {
      return _user.emailId;
    };

    this.email = function () {
      return _user.email;
    };

    this.username = function () {
      return _user.username;
    };

    /**
     * Return the name of the user
     * @return string first and last name
     **/
    this.name = function () {
      return _user.firstName + ' ' + _user.lastName;
    };

    this.isActive = function () {
      if (_user.status === 'Active') {
        return true;
      } else {
        return false;
      }
    };

    /**
     * Figure out if this user is logged in or not
     * @return boolean valid user data
     **/
    this.loggedIn = function () {
      if (_user.userId !== undefined) {
        return true;
      }

      return false;
    };

    /**
     * Return the role of this user
     * @return string user's role
     **/
    this.permissions = function () {
      return _user.role;
    };

    /**
     * Check if the user is a requester
     * @return boolean
     **/
    this.requester = function () {
      return _user.role === 'requester' ? true : false;
    };

    /**
     * Check if the user is a data destination manager
     * @return boolean
     **/
    this.genisis2Mgr = function () {
      return _user.role === 'Genisis2 Manager' ? true : false;
    };

    /**
     * Check if the user is a data source manager
     * @return boolean
     **/
    this.vinciMgr = function () {
      return _user.role === 'VINCI Manager' ? true : false;
    };

    /**
     * Check if the user is a admin
     * @return boolean
     **/
    this.Administrator = function () {
      return _user.role === 'Administrator' ? true : false;
    };

    this.allowedToAccess = function (path) {
      switch (path) {
      case 'copyRequest':
        if (this.vinciMgr()) {
          return true;
          //return false;
        } else {
          return true;
        }
        break;
      case 'createRequest':
        if (this.vinciMgr()) {
          return true;
          //return false;
        } else {
          return true;
        }
        break;
      case 'systemAdministration':
        if (this.Administrator()) {
          return true;
        } else {
          return false;
        }
        break;
      case null:
        return true;
      }
    };
  }
]);